//

// Fragment shader for Color Push transition
//
// Author: Jeff Brown
//

uniform sampler2DRect texUnit;
uniform sampler2DRect inTexUnit;
uniform sampler2DRect outTexUnit;

uniform vec4 textureRect;


uniform int hasTextureIn;  // 0 = no texture in, 1 = has texture in 
uniform int hasTextureOut;  // 0 = no texture in, 1 = has texture in 
uniform float inAlphaValue; 
uniform float outAlphaValue; 
uniform int isScreenRendered; // 0 - NO, 1 - YES
uniform float clearScreenR; 
uniform float clearScreenG; 
uniform float clearScreenB; 
uniform float clearScreenA; 

uniform float modTex0;
uniform float modTex1;
uniform float modScreen;
uniform int mode;
uniform  vec4 modulateColor;
varying vec2 gUV;
varying vec2 gUV2; 
const float kSmallValue = 1.0e-3; 

void main(void)
{
	 if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else
    {
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w;

        vec4 outputColor;
        vec4 red,green,blue;
        vec2 tmp;

        float seam;
        seam=textureWidth*inAlphaValue;

        if(gUV.x>=seam)
        {
            tmp=gUV;
            tmp.x-=seam;
            red=texture2DRect(outTexUnit,tmp)*vec4(1.,0.,0.,1.);
            red*=modTex1;
        }
        else
        {
            tmp=gUV2;
            tmp.x+=(textureWidth-seam);
            red=texture2DRect(inTexUnit,tmp)*vec4(1.,0.,0.,1.);
            red*=modTex0;
        }
        seam=textureWidth-textureWidth*inAlphaValue;
        if(gUV.x<=seam)
        {
            tmp=gUV;
            tmp.x+=(textureWidth-seam);
            green=texture2DRect(outTexUnit,tmp)*vec4(0.,1.,0.,1.);
            green*=modTex1;
        }
        else
        {
            tmp=gUV2;
            tmp.x-=seam;
            green=texture2DRect(inTexUnit,tmp)*vec4(0.,1.,0.,1.);
            green*=modTex0;
        }
        seam=textureHeight*inAlphaValue;
        if(gUV.y>=seam)
        {
            tmp=gUV;
            tmp.y-=seam;
            blue=texture2DRect(outTexUnit,tmp)*vec4(0.,0.,1.,1.);
            blue*=modTex1;
        }
        else
        {
            tmp=gUV2;
            tmp.y+=(textureHeight-seam);
            blue=texture2DRect(inTexUnit,tmp)*vec4(0.,0.,1.,1.);
            blue*=modTex0;
        }
        
        gl_FragColor = red+green+blue;
        gl_FragColor.a=red.a;
    }
}


